/*
 * Decompiled with CFR 0.152.
 */
package anon.anonudp.mixmessage;

import anon.anonudp.exception.DuplicateFragmentFound;
import anon.anonudp.exception.MessageIdMismatch;
import anon.anonudp.mixmessage.Fragment;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;

class Message {
    private final int id;
    private final HashMap payloads;
    private int fragment_count;

    public Message(int id) {
        this.id = id;
        this.payloads = new HashMap();
        this.fragment_count = -1;
    }

    public void addFragment(Fragment fragment) {
        if (fragment.getMessage_id() != this.id) {
            throw new MessageIdMismatch(this.id, fragment.getMessage_id());
        }
        Integer fragmentNumber = new Integer(fragment.getFragment_number());
        if (this.payloads.containsKey(fragmentNumber)) {
            throw new DuplicateFragmentFound(fragmentNumber);
        }
        this.payloads.put(fragmentNumber, fragment.getPayload());
        if (fragment.isLast()) {
            this.fragment_count = fragment.getFragment_number() + 1;
        }
    }

    public boolean isDone() {
        return this.fragment_count > 0 && this.payloads.size() == this.fragment_count;
    }

    public byte[] getPayload() {
        if (!this.isDone()) {
            return new byte[0];
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            for (int i = 0; i < this.fragment_count; ++i) {
                byte[] payloadPart = (byte[])this.payloads.get(new Integer(i));
                bos.write(payloadPart);
            }
            return bos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    public int getId() {
        return this.id;
    }
}

