/*
 * Decompiled with CFR 0.152.
 */
package anon.anonudp.mixpacket;

import anon.anonudp.mixmessage.crypto.PublicKey;
import anon.anonudp.mixpacket.IPacket;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class InitPacket
implements IPacket {
    public static final int CHANNEL_KEY_ONION_SIZE = 96;
    public static final int PAYLOAD_SIZE = 6;
    private final int channelID;
    private final byte[] messageID;
    private final PublicKey publicKey;
    private final byte[] channelKeyOnion;
    private final byte[] payloadOnion;

    public InitPacket(int channelID, byte[] messageID, PublicKey publicKey, byte[] channelKeyOnion, byte[] payloadOnion) {
        this.channelID = channelID;
        this.messageID = messageID;
        this.publicKey = publicKey;
        this.channelKeyOnion = channelKeyOnion;
        this.payloadOnion = payloadOnion;
    }

    PublicKey getPublicKey() {
        return this.publicKey;
    }

    byte[] getChannelKeyOnion() {
        return this.channelKeyOnion;
    }

    public byte[] getPayloadOnion() {
        return this.payloadOnion;
    }

    private byte[] toBytes() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(this.publicKey.toBytes());
        bos.write(this.channelKeyOnion);
        bos.write(this.payloadOnion);
        return bos.toByteArray();
    }

    public byte getPacketType() {
        return 2;
    }

    public byte[] getMessageID() {
        return this.messageID;
    }

    public int getChannelID() {
        return this.channelID;
    }

    public byte[] getData() throws IOException {
        return this.toBytes();
    }

    public boolean equals(Object obj) {
        if (obj instanceof InitPacket) {
            return this.equals((InitPacket)obj);
        }
        return super.equals(obj);
    }

    boolean equals(InitPacket otherPacket) {
        boolean is_equal = this.channelID == otherPacket.getChannelID();
        is_equal = is_equal && Arrays.equals(this.messageID, otherPacket.getMessageID());
        is_equal = is_equal && this.publicKey == otherPacket.getPublicKey();
        is_equal = is_equal && this.channelKeyOnion == otherPacket.getChannelKeyOnion();
        is_equal = is_equal && this.payloadOnion == otherPacket.getPayloadOnion();
        return is_equal;
    }
}

