/*
 * Decompiled with CFR 0.152.
 */
package anon.infoservice;

import anon.crypto.AbstractX509AlternativeName;
import anon.crypto.CertPath;
import anon.crypto.JAPCertificate;
import anon.crypto.MultiCertPath;
import anon.crypto.MyX509Extensions;
import anon.crypto.X509DistinguishedName;
import anon.crypto.X509SubjectAlternativeName;
import anon.infoservice.AbstractDatabaseEntry;
import anon.infoservice.OperatorAddress;
import anon.terms.TermsAndConditions;
import anon.util.Util;
import anon.util.XMLUtil;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ServiceOperator
extends AbstractDatabaseEntry {
    public static final String XML_ELEMENT_NAME = "Operator";
    public static final String XML_ELEMENT_ORGANISATION = "Organisation";
    public static final String XML_ELEMENT_COUNTRYCODE = "CountryCode";
    public static final String XML_ELEMENT_URL = "URL";
    public static final String XML_ELEMENT_ORG_UNIT = "OrganisationalUnit";
    public static final String XML_ELEMENT_EMAIL = "EMail";
    public static final String XML_ELEMENT_EMAIL_SPAMSAFE = "Liame";
    private static final String AT_SUBSTITUTE = "([at]";
    private static final String DOT_SUBSTITUTE = "([dot]";
    private static final boolean SPAM_SAFE = true;
    private String m_strOrganization;
    private String m_strOrgUnit;
    private String m_strUrl;
    private String m_strEmail;
    private String m_countryCode;
    private String m_commonName;
    private long m_lastUpdate;
    private String m_strID;
    private MultiCertPath m_certPath;

    public ServiceOperator(JAPCertificate operatorCertificate) {
        super(Long.MAX_VALUE);
        X509DistinguishedName subject = operatorCertificate.getSubject();
        this.m_certPath = null;
        this.m_strOrganization = subject.getOrganisation();
        this.m_commonName = subject.getCommonName();
        if (this.m_strOrganization == null || this.m_strOrganization.trim().length() == 0) {
            this.m_strOrganization = subject.getCommonName();
        }
        this.m_countryCode = subject.getCountryCode();
        this.m_strOrgUnit = subject.getOrganisationalUnit();
        this.m_strEmail = subject.getE_EmailAddress();
        if (this.m_strEmail == null || this.m_strEmail.trim().length() == 0) {
            this.m_strEmail = subject.getEmailAddress();
        }
        Vector extensionsFound = operatorCertificate.getExtensions().getExtensions(X509SubjectAlternativeName.IDENTIFIER);
        block2: for (int j = 0; j < extensionsFound.size(); ++j) {
            X509SubjectAlternativeName alternativeName = (X509SubjectAlternativeName)extensionsFound.elementAt(j);
            Vector tags = alternativeName.getTags();
            Vector values = alternativeName.getValues();
            if (tags.size() != values.size()) continue;
            for (int i = 0; i < tags.size(); ++i) {
                if (!tags.elementAt(i).equals(AbstractX509AlternativeName.TAG_URL)) continue;
                try {
                    this.m_strUrl = new URL(values.elementAt(i).toString()).toString();
                }
                catch (Exception a_e) {}
                continue block2;
            }
        }
        this.m_strID = operatorCertificate.getSubjectKeyIdentifierConcatenated();
        if (this.m_strID == null) {
            LogHolder.log(1, LogType.DB, "Could not create ID for ServiceOperator entry!");
            this.m_strID = "";
        }
    }

    public ServiceOperator(Node a_node, MultiCertPath a_certPath, long a_lastUpdate) {
        super(Long.MAX_VALUE);
        CertPath path;
        String strOrganization = XMLUtil.parseValue(XMLUtil.getFirstChildByName(a_node, XML_ELEMENT_ORGANISATION), null);
        if (strOrganization == null) {
            strOrganization = XMLUtil.parseValue(XMLUtil.getFirstChildByName(a_node, "Organization"), null);
        }
        this.m_certPath = a_certPath;
        this.m_lastUpdate = a_lastUpdate;
        if (this.m_certPath != null && (path = this.m_certPath.getPath()) != null && path.getSecondCertificate() != null) {
            int i;
            X509DistinguishedName subject = path.getSecondCertificate().getSubject();
            this.m_strOrganization = subject.getOrganisation();
            this.m_commonName = subject.getCommonName();
            if (this.m_strOrganization == null || this.m_strOrganization.trim().length() == 0) {
                this.m_strOrganization = subject.getCommonName();
            }
            if (this.m_strOrganization != null && this.m_strOrganization.trim().length() != 0) {
                strOrganization = this.m_strOrganization;
            }
            this.m_countryCode = subject.getCountryCode();
            this.m_strOrgUnit = subject.getOrganisationalUnit();
            this.m_strEmail = subject.getE_EmailAddress();
            if (this.m_strEmail == null || this.m_strEmail.trim().length() == 0) {
                this.m_strEmail = subject.getEmailAddress();
            }
            MyX509Extensions extensions = path.getSecondCertificate().getExtensions();
            Vector extensionsFound = extensions.getExtensions(X509SubjectAlternativeName.IDENTIFIER);
            block2: for (int j = 0; j < extensionsFound.size(); ++j) {
                X509SubjectAlternativeName alternativeName = (X509SubjectAlternativeName)extensionsFound.elementAt(j);
                Vector tags = alternativeName.getTags();
                Vector values = alternativeName.getValues();
                if (tags.size() != values.size()) continue;
                for (i = 0; i < tags.size(); ++i) {
                    if (!tags.elementAt(i).equals(AbstractX509AlternativeName.TAG_URL)) continue;
                    try {
                        this.m_strUrl = new URL(values.elementAt(i).toString()).toString();
                    }
                    catch (Exception a_e) {}
                    continue block2;
                }
            }
            Vector vecCertPaths = this.m_certPath.getPaths();
            Vector<JAPCertificate> vecCertificates = new Vector<JAPCertificate>();
            for (i = 0; i < vecCertPaths.size(); ++i) {
                JAPCertificate certTemp = ((CertPath)vecCertPaths.elementAt(i)).getSecondCertificate();
                if (certTemp == null) continue;
                vecCertificates.addElement(certTemp);
            }
            if (vecCertPaths.size() == 0) {
                LogHolder.log(3, LogType.CRYPTO, "No certificate paths for ServiceOperator entry available!");
            } else if (vecCertificates.size() == 0) {
                LogHolder.log(3, LogType.CRYPTO, "No operator certificates for ServiceOperator entry available!");
            }
            this.m_strID = JAPCertificate.calculateXORofSKIs(vecCertificates);
        }
        if (this.m_strID == null) {
            LogHolder.log(1, LogType.DB, "Could not create ID for ServiceOperator entry for the organization '" + strOrganization + "'! The respective operator certificate is missing.");
            this.m_strID = "";
        }
    }

    public long getVersionNumber() {
        return this.m_lastUpdate;
    }

    public long getLastUpdate() {
        return this.m_lastUpdate;
    }

    public String getId() {
        return this.m_strID;
    }

    public String getEMail() {
        return this.m_strEmail;
    }

    public String getEMailSpamSafe() {
        if (this.m_strEmail != null) {
            this.m_strEmail = Util.replaceAll(this.m_strEmail, "@", AT_SUBSTITUTE);
            this.m_strEmail = Util.replaceAll(this.m_strEmail, ".", DOT_SUBSTITUTE);
        }
        return this.m_strEmail;
    }

    public String getOrganization() {
        return this.m_strOrganization;
    }

    public String getCommonName() {
        return this.m_commonName;
    }

    public String getOrganizationUnit() {
        return this.m_strOrgUnit;
    }

    public MultiCertPath getCertPath() {
        return this.m_certPath;
    }

    public JAPCertificate getCertificate() {
        JAPCertificate cert;
        if (this.m_certPath == null || this.m_certPath.getPath() == null || (cert = this.m_certPath.getPath().getSecondCertificate()) == null) {
            return null;
        }
        return cert;
    }

    public String getUrl() {
        return this.m_strUrl;
    }

    public String getCountryCode() {
        return this.m_countryCode;
    }

    public Element toXMLElement(Document ownerDocument) {
        return this.toXMLElement(ownerDocument, true);
    }

    public boolean hasTermsAndConditions() {
        return TermsAndConditions.getTermsAndConditions(this) != null;
    }

    public Element toXMLElement(Document ownerDocument, boolean spamSafe) {
        return this.toXMLElement(ownerDocument, null, spamSafe);
    }

    public Element toXMLElement(Document ownerDocument, OperatorAddress address, boolean spamSafe) {
        if (ownerDocument == null) {
            return null;
        }
        Element mixOperatorElement = ownerDocument.createElement(XML_ELEMENT_NAME);
        if (this.m_strOrganization != null) {
            XMLUtil.createChildElementWithValue(mixOperatorElement, XML_ELEMENT_ORGANISATION, XMLUtil.filterXMLChars(this.m_strOrganization));
        }
        if (this.m_strUrl != null) {
            XMLUtil.createChildElementWithValue(mixOperatorElement, XML_ELEMENT_URL, XMLUtil.filterXMLChars(this.m_strUrl));
        }
        if (this.m_countryCode != null) {
            XMLUtil.createChildElementWithValue(mixOperatorElement, XML_ELEMENT_COUNTRYCODE, XMLUtil.filterXMLChars(this.m_countryCode));
        }
        if (this.m_strOrgUnit != null) {
            XMLUtil.createChildElementWithValue(mixOperatorElement, XML_ELEMENT_ORG_UNIT, XMLUtil.filterXMLChars(this.m_strOrgUnit));
        }
        if (this.m_strEmail != null) {
            XMLUtil.createChildElementWithValue(mixOperatorElement, spamSafe ? XML_ELEMENT_EMAIL_SPAMSAFE : XML_ELEMENT_EMAIL, spamSafe ? XMLUtil.filterXMLChars(this.getEMailSpamSafe()) : XMLUtil.filterXMLChars(this.getEMail()));
        }
        if (address != null) {
            Enumeration e = address.getAddressAsNodeList(ownerDocument);
            while (e.hasMoreElements()) {
                mixOperatorElement.appendChild((Element)e.nextElement());
            }
        }
        return mixOperatorElement;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object a_obj) {
        if (a_obj == null || !(a_obj instanceof ServiceOperator)) {
            return false;
        }
        ServiceOperator op = (ServiceOperator)a_obj;
        return this.getId().equals(op.getId());
    }
}

