/*
 * Decompiled with CFR 0.152.
 */
package captcha.graphics;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;

public class RgbMemoryImageConsumer
implements ImageConsumer {
    private int[] m_rgbPixels;
    private ImageProducer m_imageProducer;
    private int m_width;
    private int m_height;
    private Object m_productionLock;
    private boolean m_productionComplete;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RgbMemoryImageConsumer(ImageProducer a_imageProducer) {
        this.m_imageProducer = a_imageProducer;
        this.m_width = 0;
        this.m_height = 0;
        this.m_rgbPixels = new int[0];
        this.m_productionLock = new Object();
        this.m_productionComplete = false;
        this.m_imageProducer.startProduction(this);
        Object object = this.m_productionLock;
        synchronized (object) {
            if (!this.m_productionComplete) {
                try {
                    this.m_productionLock.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imageComplete(int a_status) {
        this.m_imageProducer.removeConsumer(this);
        Object object = this.m_productionLock;
        synchronized (object) {
            this.m_productionComplete = true;
            this.m_productionLock.notify();
        }
    }

    @Override
    public void setColorModel(ColorModel a_colorModel) {
    }

    @Override
    public void setDimensions(int a_width, int a_height) {
        this.m_width = a_width;
        this.m_height = a_height;
        this.m_rgbPixels = new int[this.m_width * this.m_height];
    }

    @Override
    public void setHints(int a_hints) {
    }

    @Override
    public void setPixels(int a_posX, int a_posY, int a_width, int a_height, ColorModel a_colorModel, int[] a_pixels, int a_offset, int a_scansize) {
        for (int y = 0; y < a_height; ++y) {
            for (int x = 0; x < a_width; ++x) {
                this.m_rgbPixels[(y + a_posY) * this.m_width + (x + a_posX)] = a_colorModel.getRGB(a_pixels[y * a_scansize + x + a_offset]);
            }
        }
    }

    @Override
    public void setPixels(int a_posX, int a_posY, int a_width, int a_height, ColorModel a_colorModel, byte[] a_pixels, int a_offset, int a_scansize) {
        for (int y = 0; y < a_height; ++y) {
            for (int x = 0; x < a_width; ++x) {
                this.m_rgbPixels[(y + a_posY) * this.m_width + (x + a_posX)] = a_colorModel.getRGB(a_pixels[y * a_scansize + x + a_offset]);
            }
        }
    }

    public void setProperties(Hashtable a_properties) {
    }

    public int getWidth() {
        return this.m_width;
    }

    public int getHeight() {
        return this.m_height;
    }

    public int[] getRgbPixels() {
        int[] pixelData = new int[this.m_rgbPixels.length];
        System.arraycopy(this.m_rgbPixels, 0, pixelData, 0, this.m_rgbPixels.length);
        return pixelData;
    }
}

