/*
 * Decompiled with CFR 0.152.
 */
package infoservice.agreement.paxos;

import infoservice.agreement.paxos.IPaxosTarget;
import infoservice.agreement.paxos.PaxosObject;
import infoservice.agreement.paxos.messages.PaxosMessage;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class PaxosCommunicator
extends PaxosObject {
    protected Hashtable m_targets = new Hashtable();

    public void multicast(PaxosMessage a_msg) {
        Enumeration en = this.m_targets.keys();
        while (en.hasMoreElements()) {
            IPaxosTarget target = (IPaxosTarget)this.m_targets.get(en.nextElement());
            this.sendMessage(a_msg, target);
        }
    }

    public void sendMessage(String a_id, PaxosMessage a_msg) {
        IPaxosTarget target = (IPaxosTarget)this.m_targets.get(a_id);
        this.sendMessage(a_msg, target);
    }

    public Hashtable getTargets() {
        return this.m_targets;
    }

    protected int getQuorumStrong() {
        int result = (int)((double)(this.getN() + this.getF()) / 2.0);
        return result;
    }

    protected int getQuorumDecideWeak() {
        int result = (int)((double)(this.getN() + 3 * this.getF()) / 2.0);
        return result;
    }

    protected int getQuorumDecideStrong() {
        int result = 2 * this.getF();
        return result;
    }

    protected int getF() {
        int result = this.nextLower(0.3333333333333333 * (double)this.getN());
        return result;
    }

    public int getN() {
        return this.m_targets.size();
    }

    public int getQuorumTwoThird() {
        return this.nextUpper((double)(2 * this.getN()) / 3.0);
    }

    public void setTargets(Hashtable a_targets) {
        this.m_targets = a_targets;
    }

    private int nextUpper(double a_bottom) {
        int tmp = (int)a_bottom;
        if ((double)tmp < a_bottom) {
            ++tmp;
        }
        return tmp;
    }

    private int nextLower(double a_roof) {
        int tmp = (int)a_roof;
        if ((double)tmp >= a_roof) {
            --tmp;
        }
        return tmp;
    }

    public abstract void sendMessage(PaxosMessage var1, IPaxosTarget var2);

    protected abstract String getIdentifier();
}

