/*
 * Decompiled with CFR 0.152.
 */
package infoservice.japforwarding.captcha.test;

import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;

public class BinaryImageExtractor {
    public static Image binaryToImage(byte[] a_binaryData) {
        Image resultImage = null;
        try {
            ByteArrayInputStream binaryData = new ByteArrayInputStream(a_binaryData);
            DataInputStream transformer = new DataInputStream(binaryData);
            int width = transformer.readInt();
            int height = transformer.readInt();
            if (width < 0 || height < 0 || a_binaryData.length != 8 + (height * width + 7) / 8) {
                throw new Exception("BinaryImageExtractor: binaryToImage: The binary image has an invalid size.");
            }
            int[] pixels = new int[width * height];
            int currentByte = binaryData.read();
            for (int i = 0; i < width * height; ++i) {
                pixels[i] = (currentByte & 0x80) == 128 ? Color.darkGray.getRGB() : Color.white.getRGB();
                currentByte <<= 1;
                if (i % 8 != 7) continue;
                currentByte = binaryData.read();
            }
            resultImage = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(width, height, pixels, 0, width));
        }
        catch (Exception e) {
            resultImage = null;
        }
        return resultImage;
    }
}

