/*
 * Decompiled with CFR 0.152.
 */
package infoservice.mailsystem.central;

import infoservice.mailsystem.central.AbstractMailSystemCommand;
import infoservice.mailsystem.central.MailMessages;
import infoservice.mailsystem.central.commands.BanWarningCommand;
import infoservice.mailsystem.central.commands.GetForwarderCommand;
import infoservice.mailsystem.central.commands.HelpCommand;
import java.util.Locale;
import java.util.StringTokenizer;

public class CommandFactory {
    private static final Locale DEFAULT_LANGUAGE = Locale.ENGLISH;
    private static final int COMMAND_GETHELP = 0;
    private static final int COMMAND_GETFORWARDER = 1;
    private static final int COMMAND_BANMESSAGE = 2;
    private static final int DEFAULT_COMMAND = 0;

    public static AbstractMailSystemCommand getCommandImplementation(String a_mailSubject, boolean a_banMessage) {
        int commandCode = 0;
        Locale languageToUse = DEFAULT_LANGUAGE;
        if (a_banMessage) {
            commandCode = 2;
        }
        if (a_mailSubject != null) {
            StringTokenizer stMailCommand = new StringTokenizer(a_mailSubject, " ");
            try {
                String language;
                String command = stMailCommand.nextToken().trim();
                if (!a_banMessage) {
                    if (command.equalsIgnoreCase("GetHelp")) {
                        commandCode = 0;
                    }
                    if (command.equalsIgnoreCase("GetForwarder")) {
                        commandCode = 1;
                    }
                }
                if ((language = stMailCommand.nextToken().trim()).equalsIgnoreCase("en")) {
                    languageToUse = Locale.ENGLISH;
                }
                if (language.equalsIgnoreCase("de")) {
                    languageToUse = Locale.GERMAN;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        AbstractMailSystemCommand commandImplementation = null;
        commandImplementation = commandCode == 1 ? new GetForwarderCommand(new MailMessages(languageToUse)) : (commandCode == 2 ? new BanWarningCommand(new MailMessages(languageToUse)) : new HelpCommand(new MailMessages(languageToUse)));
        return commandImplementation;
    }
}

