/*
 * Decompiled with CFR 0.152.
 */
package infoservice.tor;

import HTTPClient.HTTPConnection;
import anon.infoservice.HTTPConnectionFactory;
import anon.infoservice.ListenerInterface;
import java.net.URL;
import logging.LogHolder;
import logging.LogType;

public class MixminionDirectoryAgent
implements Runnable {
    private static final String DEFAULT_DIRECTORY_FILE = "/Directory.gz";
    private static MixminionDirectoryAgent ms_mdaInstance;
    private URL m_urlDirectoryServer = null;
    private byte[] m_currentMixminionNodesList = null;
    private long m_updateInterval = -1L;

    public static MixminionDirectoryAgent getInstance() {
        if (ms_mdaInstance == null) {
            ms_mdaInstance = new MixminionDirectoryAgent();
        }
        return ms_mdaInstance;
    }

    private MixminionDirectoryAgent() {
    }

    public void addDirectoryServer(URL directoryServer) {
        this.m_urlDirectoryServer = directoryServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startUpdateThread(long a_updateInterval) {
        MixminionDirectoryAgent mixminionDirectoryAgent = this;
        synchronized (mixminionDirectoryAgent) {
            if (this.m_updateInterval == -1L && a_updateInterval > 0L) {
                this.m_updateInterval = a_updateInterval;
                Thread fetchThread = new Thread((Runnable)this, "MixminionDirectoryAgent Update Thread");
                fetchThread.setPriority(1);
                fetchThread.setDaemon(true);
                fetchThread.start();
            }
        }
    }

    public byte[] getMixminionNodesList() {
        return this.m_currentMixminionNodesList;
    }

    @Override
    public void run() {
        while (true) {
            LogHolder.log(6, LogType.NET, "MixminionDirectoryAgent: run: Try to fetch the mixminion nodes list from the known mixminion directory servers.");
            try {
                HTTPConnection con = HTTPConnectionFactory.getInstance().createHTTPConnection(new ListenerInterface(this.m_urlDirectoryServer.getHost(), this.m_urlDirectoryServer.getPort()));
                con.removeModule(Class.forName("HTTPClient.ContentEncodingModule"));
                this.m_currentMixminionNodesList = con.Get(this.m_urlDirectoryServer.getFile()).getData();
            }
            catch (Exception e) {
                LogHolder.log(3, LogType.MISC, "MixminionDirectoryAgent: run: Error while creating the XML structure with the Mixminion nodes list: " + e.toString());
                this.m_currentMixminionNodesList = null;
            }
            if (this.m_currentMixminionNodesList == null) {
                LogHolder.log(3, LogType.NET, "MixminionDirectoryAgent: run: Could not fetch the mixminion nodes list from the known tor directory servers.");
            } else {
                LogHolder.log(7, LogType.NET, "MixminionDirectoryAgent: run: Fetched the list of mixminion nodes successfully.");
            }
            try {
                Thread.sleep(this.m_updateInterval);
            }
            catch (Exception exception) {
            }
        }
    }
}

