/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.ClipboardCopier;
import gui.dialog.JAPDialog;
import java.awt.Cursor;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;

public class JapHtmlPane
extends JScrollPane
implements HyperlinkListener {
    private JEditorPane html;
    private URL url;
    private Cursor cursor;
    private static final String MAILTO = "mailto";

    public JapHtmlPane(String a_textToShow, JViewport customizedViewPort) {
        this.html = new JEditorPane("text/html", a_textToShow);
        new ClipboardCopier(true).register(this.html);
        this.html.setEditable(false);
        this.html.addHyperlinkListener(this);
        if (customizedViewPort != null) {
            this.setViewport(customizedViewPort);
        }
        this.getViewport().add(this.html);
        this.cursor = this.html.getCursor();
    }

    public JEditorPane getPane() {
        return this.html;
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.linkActivated(e.getURL());
        } else if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            this.html.setCursor(Cursor.getPredefinedCursor(12));
        } else if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
            this.html.setCursor(this.cursor);
        }
    }

    private void linkActivated(URL u) {
        this.html.setCursor(Cursor.getPredefinedCursor(3));
        SwingUtilities.invokeLater(new PageLoader(u));
    }

    private void loadURL(URL a_url) {
        this.html.setCursor(Cursor.getPredefinedCursor(3));
        SwingUtilities.invokeLater(new PageLoader(a_url));
    }

    private final class PageLoader
    implements Runnable {
        PageLoader(URL u) {
            JapHtmlPane.this.url = u;
        }

        public void run() {
            if (JapHtmlPane.this.url == null) {
                JapHtmlPane.this.html.setCursor(JapHtmlPane.this.cursor);
                JapHtmlPane.this.html.getParent().repaint();
            } else if (JapHtmlPane.this.url.getProtocol().startsWith("file") || JapHtmlPane.this.url.getProtocol().startsWith("zip") || JapHtmlPane.this.url.getProtocol().startsWith("jar") || JapHtmlPane.this.url.getProtocol().startsWith("systemresource")) {
                Document doc = JapHtmlPane.this.html.getDocument();
                try {
                    JapHtmlPane.this.html.setPage(JapHtmlPane.this.url);
                }
                catch (IOException ioe) {
                    JapHtmlPane.this.html.setDocument(doc);
                    JapHtmlPane.this.getToolkit().beep();
                }
                finally {
                    JapHtmlPane.this.url = null;
                    SwingUtilities.invokeLater(this);
                }
            } else {
                boolean success = true;
                if (!success) {
                    JapHtmlPane.this.html.setCursor(JapHtmlPane.this.cursor);
                }
            }
        }

        private class ExternalLinkedInformation
        extends JAPDialog.LinkedInformationAdapter {
            private URL m_url;

            public ExternalLinkedInformation(URL a_url) {
                this.m_url = a_url;
            }

            public String getMessage() {
                return this.m_url.toString();
            }

            public int getType() {
                return 2;
            }

            public boolean isApplicationModalityForced() {
                return true;
            }
        }
    }
}

