/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.tools;

import anon.crypto.PKCS10CertificationRequest;
import anon.crypto.PKCS12;
import anon.platform.AbstractOS;
import anon.platform.WindowsOS;
import anon.util.Base64;
import gui.GUIUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import mixconfig.MixConfig;
import mixconfig.MixConfiguration;
import mixconfig.network.ConnectionData;
import mixconfig.network.IncomingConnectionTableModel;
import mixconfig.panels.CertPanel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EmailComposer {
    public static void composeEmail() throws IOException, URISyntaxException {
        String mixCertX509;
        String opCertX509;
        MixConfiguration mixConf = MixConfig.getMixConfiguration();
        String sMixName = mixConf.getValue("General/MixName");
        String sOperator = mixConf.getValue("Description/Operator/Organisation");
        String sMonitoringHost = mixConf.getValue("Network/ServerMonitoring/Host");
        String sMonitoringPort = mixConf.getValue("Network/ServerMonitoring/Port");
        StringBuffer sbURL = new StringBuffer("mailto:certification@jondos.de?");
        sbURL.append("subject=Certificates for '");
        sbURL.append(sMixName);
        sbURL.append("'&");
        sbURL.append("body=Operator Organization: ");
        sbURL.append(sOperator);
        sbURL.append("\nMix Name: ");
        sbURL.append(sMixName);
        sbURL.append("\n\n");
        sbURL.append("Listener Interfaces:\n");
        IncomingConnectionTableModel dummy = EmailComposer.getIncomingInterfaces();
        ConnectionData data = null;
        for (int i = 0; i < dummy.getRowCount(); ++i) {
            data = dummy.getData(i);
            sbURL.append("- ");
            sbURL.append(data.getHostname());
            sbURL.append(":");
            sbURL.append(data.getPort());
            sbURL.append("\n");
        }
        sbURL.append("\n");
        sbURL.append("Server Monitoring:\n- ");
        sbURL.append(sMonitoringHost);
        sbURL.append(":");
        sbURL.append(sMonitoringPort);
        sbURL.append("\n\n");
        StringBuffer sbCerts = new StringBuffer();
        String sPKCS12 = mixConf.getValue("Certificates/OperatorOwnCertificate/X509PKCS12");
        if (sPKCS12 != null && !sPKCS12.equals("")) {
            int i;
            byte[] b = Base64.decode(sPKCS12);
            PKCS12 privateCertificate = null;
            Vector<CertPanel> panels = CertPanel.getCertPanels();
            Vector<String> passwords = new Vector<String>();
            for (i = 0; i < panels.size(); ++i) {
                CertPanel p = panels.get(i);
                if (!p.getCertName().equals("Operator Certificate")) continue;
                passwords.add(new String(p.getPrivateCertPassword()));
            }
            for (i = 0; i < passwords.size() && (privateCertificate = PKCS12.getInstance(b, (String)passwords.get(i))) == null; ++i) {
            }
            if (privateCertificate != null) {
                PKCS10CertificationRequest request = new PKCS10CertificationRequest(privateCertificate);
                sbCerts.append("Certificate Request (P10):\n\n");
                sbCerts.append(new String(request.toByteArray(true)));
                sbCerts.append("\n");
            }
        }
        if ((opCertX509 = mixConf.getValue("Certificates/OperatorOwnCertificate/X509Certificate")) != null && !opCertX509.equals("")) {
            sbCerts.append("Operator Certificate (PEM):\n\n-----BEGIN CERTIFICATE-----\n");
            sbCerts.append(opCertX509);
            sbCerts.append("\n-----END CERTIFICATE-----\n\n");
        }
        if ((mixCertX509 = mixConf.getValue("Certificates/OwnCertificate/X509Certificate")) != null && !mixCertX509.equals("")) {
            sbCerts.append("Mix Certificate (PEM):\n\n-----BEGIN CERTIFICATE-----\n");
            sbCerts.append(mixCertX509);
            sbCerts.append("\n-----END CERTIFICATE-----\n\n");
        }
        AbstractOS os = AbstractOS.getInstance();
        LogHolder.log(7, LogType.MISC, "Detected OS is " + os.getClass().getSimpleName());
        if (os instanceof WindowsOS) {
            GUIUtils.saveTextToClipboard(sbCerts.toString(), MixConfig.getMainWindow());
            sbURL.append("CERTIFICATES ARE CURRENTLY IN THE CLIPBOARD,\n");
            sbURL.append("PLEASE PASTE HERE!\n\n");
        } else {
            sbURL.append(sbCerts);
        }
        String sURL = EmailComposer.encodeURL(sbURL.toString());
        LogHolder.log(7, LogType.MISC, "Length of URL string is " + sURL.length());
        AbstractOS.getInstance().openURL(new URL(sURL));
    }

    private static IncomingConnectionTableModel getIncomingInterfaces() {
        IncomingConnectionTableModel model = new IncomingConnectionTableModel();
        NodeList nl = MixConfig.getMixConfiguration().getDocument().getElementsByTagName("ListenerInterfaces");
        for (int i = 0; i < nl.getLength(); ++i) {
            Node parent = nl.item(i).getParentNode();
            if (!parent.getNodeName().equals("Network") || !(parent = parent.getParentNode()).getNodeName().equals("MixConfiguration")) continue;
            model.readFromElement((Element)nl.item(i));
        }
        return model;
    }

    private static String encodeURL(String sURL) {
        sURL = sURL.replace(" ", "%20");
        sURL = sURL.replace("\n", "%0D%0A");
        return sURL;
    }
}

