/*
 * Decompiled with CFR 0.152.
 */
package anon.client;

import anon.client.FixedRatioChannelsDescription;
import anon.client.ITrustModel;
import anon.client.IllegalTCRequestPostConditionException;
import anon.client.MixPacket;
import anon.client.MixParameters;
import anon.client.TrustException;
import anon.client.UnknownProtocolVersionException;
import anon.client.crypto.ASymMixCipherPlainRSA;
import anon.client.crypto.ASymMixCipherRSAOAEP;
import anon.client.crypto.ControlChannelCipher;
import anon.client.crypto.IASymMixCipher;
import anon.client.crypto.KeyPool;
import anon.client.crypto.SymCipher;
import anon.crypto.SignatureVerifier;
import anon.crypto.XMLEncryption;
import anon.crypto.XMLSignature;
import anon.infoservice.Database;
import anon.infoservice.MixCascade;
import anon.infoservice.MixInfo;
import anon.infoservice.ServiceOperator;
import anon.terms.TermsAndConditions;
import anon.terms.TermsAndConditionsMixInfo;
import anon.terms.TermsAndConditionsReadException;
import anon.terms.TermsAndConditionsRequest;
import anon.terms.TermsAndConditionsResponseHandler;
import anon.terms.template.TermsAndConditionsTemplate;
import anon.util.Base64;
import anon.util.JAPMessages;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SignatureException;
import java.text.ParseException;
import java.util.Locale;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class KeyExchangeManager {
    private int m_mixCascadeCertificateLock;
    private Object m_internalSynchronization;
    private boolean m_protocolWithTimestamp;
    private boolean m_protocolWithReplay;
    private boolean m_paymentRequired;
    private boolean m_bEnhancedChannelEncryption;
    private SymCipher m_firstMixSymmetricCipher;
    private ControlChannelCipher m_controlchannelCipher;
    private boolean m_chainProtocolWithFlowControl;
    private int m_upstreamSendMe;
    private int m_downstreamSendMe;
    private FixedRatioChannelsDescription m_fixedRatioChannelsDescription;
    private MixParameters[] m_mixParameters;
    private SymCipher m_multiplexerInputStreamCipher;
    private SymCipher m_multiplexerOutputStreamCipher;
    private MixCascade m_cascade;
    private TermsAndConditionsRequest m_tnCRequest;
    private TermsAndConditionsReadException tcrException = null;
    private boolean tcOverallAccept = true;
    static /* synthetic */ Class class$anon$infoservice$MixCascade;
    static /* synthetic */ Class class$anon$infoservice$MixInfo;

    public KeyExchangeManager(InputStream inputStream, OutputStream outputStream, MixCascade mixCascade, ITrustModel iTrustModel) throws XMLParseException, SignatureException, IOException, UnknownProtocolVersionException, TrustException, TermsAndConditionsReadException, IllegalTCRequestPostConditionException {
        try {
            Object object;
            Object object2;
            Object object3;
            Element element;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            Object object9;
            Object object10;
            Object object11;
            int n;
            int n2;
            this.m_mixCascadeCertificateLock = -1;
            this.m_internalSynchronization = new Object();
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            byte[] byArray = new byte[n2];
            for (n2 = dataInputStream.readUnsignedShort(); n2 > 0; n2 -= n) {
                n = inputStream.read(byArray, byArray.length - n2, n2);
                if (n != -1) continue;
                throw new EOFException("EOF detected while reading initial XML structure.");
            }
            Element element2 = XMLUtil.toXMLDocument(byArray).getDocumentElement();
            this.m_cascade = new MixCascade(element2, Long.MAX_VALUE, mixCascade.getId());
            TrustException trustException = null;
            SignatureException signatureException = null;
            if (mixCascade.isUserDefined()) {
                this.m_cascade.setUserDefined(true, mixCascade);
                Database.getInstance(class$anon$infoservice$MixCascade == null ? (class$anon$infoservice$MixCascade = KeyExchangeManager.class$("anon.infoservice.MixCascade")) : class$anon$infoservice$MixCascade).remove(this.m_cascade);
                Database.getInstance(class$anon$infoservice$MixCascade == null ? (class$anon$infoservice$MixCascade = KeyExchangeManager.class$("anon.infoservice.MixCascade")) : class$anon$infoservice$MixCascade).update(this.m_cascade);
                Database.getInstance(class$anon$infoservice$MixInfo == null ? (class$anon$infoservice$MixInfo = KeyExchangeManager.class$("anon.infoservice.MixInfo")) : class$anon$infoservice$MixInfo).update(new MixInfo(this.m_cascade.getCertPath()));
                iTrustModel.checkTrust(this.m_cascade);
            } else {
                MixCascade mixCascade2 = (MixCascade)Database.getInstance(class$anon$infoservice$MixCascade == null ? (class$anon$infoservice$MixCascade = KeyExchangeManager.class$("anon.infoservice.MixCascade")) : class$anon$infoservice$MixCascade).getEntryById(this.m_cascade.getId());
                if (mixCascade2 != null) {
                    if (!this.m_cascade.compareMixIDs(mixCascade2)) {
                        Database.getInstance(class$anon$infoservice$MixCascade == null ? (class$anon$infoservice$MixCascade = KeyExchangeManager.class$("anon.infoservice.MixCascade")) : class$anon$infoservice$MixCascade).remove(mixCascade2);
                    }
                    boolean bl = false;
                    boolean bl2 = false;
                    try {
                        iTrustModel.checkTrust(this.m_cascade);
                        bl = true;
                    }
                    catch (TrustException trustException2) {
                        trustException = trustException2;
                    }
                    catch (SignatureException signatureException2) {
                        signatureException = signatureException2;
                    }
                    try {
                        iTrustModel.checkTrust(mixCascade2);
                        bl2 = true;
                    }
                    catch (TrustException trustException3) {
                    }
                    catch (SignatureException signatureException3) {
                        // empty catch block
                    }
                    if (bl != bl2) {
                        Database.getInstance(class$anon$infoservice$MixCascade == null ? (class$anon$infoservice$MixCascade = KeyExchangeManager.class$("anon.infoservice.MixCascade")) : class$anon$infoservice$MixCascade).remove(mixCascade2);
                    }
                }
            }
            if (trustException != null) {
                throw trustException;
            }
            if (signatureException != null) {
                throw signatureException;
            }
            if (this.m_cascade.getMixProtocolVersion() == null) {
                throw new XMLParseException("##__null__##", "MixProtocolVersion (channel) node expected in received XML structure.");
            }
            this.m_protocolWithTimestamp = false;
            this.m_protocolWithReplay = false;
            this.m_bEnhancedChannelEncryption = false;
            this.m_paymentRequired = this.m_cascade.isPayment();
            if (!this.m_cascade.isPaymentProtocolSupported()) {
                throw new UnknownProtocolVersionException("Unsupported payment protocol version ('" + this.m_cascade.getPaymentProtocolVersion() + "').");
            }
            this.m_firstMixSymmetricCipher = null;
            this.m_controlchannelCipher = null;
            LogHolder.log(7, LogType.NET, "Cascade is using channel-protocol version '" + this.m_cascade.getMixProtocolVersion() + "'.");
            if (!this.m_cascade.getMixProtocolVersion().equals("0.2")) {
                if (this.m_cascade.getMixProtocolVersion().equals("0.4")) {
                    this.m_firstMixSymmetricCipher = new SymCipher();
                } else if (this.m_cascade.getMixProtocolVersion().equals("0.81")) {
                    this.m_protocolWithTimestamp = false;
                    this.m_protocolWithReplay = true;
                    this.m_firstMixSymmetricCipher = new SymCipher();
                } else if (this.m_cascade.getMixProtocolVersion().equalsIgnoreCase("0.9")) {
                    this.m_firstMixSymmetricCipher = new SymCipher();
                } else if (this.m_cascade.getMixProtocolVersion().equalsIgnoreCase("0.10")) {
                    this.m_firstMixSymmetricCipher = new SymCipher();
                    this.m_bEnhancedChannelEncryption = true;
                } else {
                    throw new UnknownProtocolVersionException("Unknown channel protocol version used ('" + this.m_cascade.getMixProtocolVersion() + "').");
                }
            }
            this.m_mixParameters = new MixParameters[this.m_cascade.getNumberOfMixes()];
            this.m_tnCRequest = new TermsAndConditionsRequest();
            for (int i = 0; i < this.m_cascade.getNumberOfMixes(); ++i) {
                Object object12;
                MixInfo mixInfo = this.m_cascade.getMixInfo(i);
                if (mixInfo == null) {
                    throw new XMLParseException("Could not get MixInfo object for Mix " + i + "!");
                }
                if (i > 0 && !mixInfo.isVerified()) {
                    throw new SignatureException("Received XML structure has an invalid signature for Mix " + Integer.toString(i + 1) + ".");
                }
                Element element3 = mixInfo.getXmlStructure();
                object11 = null;
                object11 = this.m_bEnhancedChannelEncryption ? new ASymMixCipherRSAOAEP() : new ASymMixCipherPlainRSA();
                this.m_mixParameters[i] = new MixParameters(mixInfo.getId(), (IASymMixCipher)object11);
                if (this.m_mixParameters[i].getMixCipher().setPublicKey(element3) != 0) {
                    throw new XMLParseException("Received XML structure contains an invalid public key for Mix " + Integer.toString(i) + ".");
                }
                if (this.m_cascade.isTermsAndConditionsConfirmationRequired()) {
                    object10 = mixInfo.getServiceOperator();
                    object9 = mixInfo.getTermsAndConditionMixInfo();
                    if (object9 != null) {
                        try {
                            object8 = TermsAndConditions.getTermsAndConditions((ServiceOperator)object10);
                            if (object8 == null || !((TermsAndConditions)object8).isMostRecent(((TermsAndConditionsMixInfo)object9).getDate()) || ((TermsAndConditions)object8).isSignatureObsolete()) {
                                boolean bl = false;
                                if (object8 != null) {
                                    TermsAndConditions.removeTermsAndConditions((TermsAndConditions)object8);
                                    bl = ((TermsAndConditions)object8).isSignatureObsolete() ? ((TermsAndConditions)object8).isAccepted() : false;
                                }
                                object8 = new TermsAndConditions((ServiceOperator)object10, ((TermsAndConditionsMixInfo)object9).getDate());
                                if (!bl) {
                                    if (this.tcrException == null) {
                                        this.tcrException = new TermsAndConditionsReadException();
                                    }
                                    this.tcrException.addTermsAndConditonsToRead((TermsAndConditions)object8);
                                } else {
                                    ((TermsAndConditions)object8).setAccepted(true);
                                }
                                TermsAndConditions.storeTermsAndConditions((TermsAndConditions)object8);
                            } else if (!((TermsAndConditions)object8).isAccepted()) {
                                if (this.tcrException == null) {
                                    this.tcrException = new TermsAndConditionsReadException();
                                }
                                this.tcrException.addTermsAndConditonsToRead((TermsAndConditions)object8);
                            }
                            object7 = JAPMessages.getLocale();
                            Object object13 = object6 = ((TermsAndConditionsMixInfo)object9).hasTranslation((Locale)object7) ? ((Locale)object7).getLanguage().trim().toLowerCase() : ((TermsAndConditionsMixInfo)object9).getDefaultLanguage();
                            if (!((String)object6).equals(((TermsAndConditionsMixInfo)object9).getDefaultLanguage()) && !((TermsAndConditions)object8).hasDefaultTranslation()) {
                                this.m_tnCRequest.addCustomizedSectionsRequest((ServiceOperator)object10, ((TermsAndConditionsMixInfo)object9).getDefaultLanguage());
                                if (TermsAndConditionsTemplate.getById(((TermsAndConditionsMixInfo)object9).getDefaultTemplateRefId(), false) == null) {
                                    this.m_tnCRequest.addTemplateRequest((ServiceOperator)object10, ((TermsAndConditionsMixInfo)object9).getDefaultLanguage(), ((TermsAndConditionsMixInfo)object9).getDefaultTemplateRefId());
                                }
                            }
                            if (TermsAndConditionsTemplate.getById((String)(object12 = ((TermsAndConditionsMixInfo)object9).getTemplateRefId((String)object6)), false) == null) {
                                this.m_tnCRequest.addTemplateRequest((ServiceOperator)object10, (String)object6, (String)object12);
                            }
                            if (!((TermsAndConditions)object8).hasTranslation((String)object6)) {
                                this.m_tnCRequest.addCustomizedSectionsRequest((ServiceOperator)object10, (String)object6);
                            }
                        }
                        catch (ParseException parseException) {
                            LogHolder.log(3, LogType.NET, "tc mix info " + ((TermsAndConditionsMixInfo)object9).getId() + " has an invalid date format: " + ((TermsAndConditionsMixInfo)object9).getDate());
                        }
                    } else {
                        LogHolder.log(4, LogType.NET, "Cascade requires Terms And Conditions confirmation but Mix " + mixInfo.getName() + " does not send any TC Infos!");
                    }
                }
                if (i == this.m_cascade.getNumberOfMixes() - 1) {
                    object10 = element3.getElementsByTagName("MixProtocolVersion");
                    if (object10.getLength() == 0) {
                        throw new XMLParseException("##__null__##", "MixProtocolVersion (chain) node expected in received XML structure.");
                    }
                    object9 = (Element)object10.item(0);
                    object8 = XMLUtil.parseValue((Node)object9, (String)null);
                    if (object8 == null) {
                        throw new XMLParseException("##__null__##", "MixProtocolVersion (chain) node has no value.");
                    }
                    object8 = ((String)object8).trim();
                    this.m_chainProtocolWithFlowControl = false;
                    this.m_fixedRatioChannelsDescription = null;
                    LogHolder.log(7, LogType.NET, "Cascade is using chain-protocol version '" + (String)object8 + "'.");
                    if (((String)object8).equals("0.3")) continue;
                    if (((String)object8).equals("0.6")) {
                        this.m_chainProtocolWithFlowControl = true;
                        object7 = XMLUtil.getFirstChildByName(element3, "FlowControl");
                        if (object7 == null) {
                            throw new XMLParseException("##__null__##", "FlowControl node expected in received XML structure.");
                        }
                        object6 = XMLUtil.getFirstChildByName((Node)object7, "UpstreamSendMe");
                        if (object6 == null) {
                            throw new XMLParseException("##__null__##", "UpstreamSendMe node expected in received XML structure.");
                        }
                        object12 = XMLUtil.getFirstChildByName((Node)object7, "DownstreamSendMe");
                        if (object12 == null) {
                            throw new XMLParseException("##__null__##", "DownstreamSendMe node expected in received XML structure.");
                        }
                        this.m_upstreamSendMe = XMLUtil.parseValue((Node)object6, -1);
                        if (this.m_upstreamSendMe <= 0) {
                            throw new XMLParseException("##__null__##", "Got wrong value for UpstreamSendMe in received XML structure.");
                        }
                        this.m_downstreamSendMe = XMLUtil.parseValue((Node)object12, -1);
                        if (this.m_downstreamSendMe > 0) continue;
                        throw new XMLParseException("##__null__##", "Got wrong value for DownstreamSendMe in received XML structure.");
                    }
                    if (((String)object8).equals("0.5")) {
                        object7 = element3.getElementsByTagName("DownstreamPackets");
                        if (object7.getLength() == 0) {
                            throw new XMLParseException("##__null__##", "DownstreamPackets node expected in received XML structure.");
                        }
                        object6 = (Element)object7.item(0);
                        int n3 = XMLUtil.parseValue((Node)object6, -1);
                        if (n3 < 1) {
                            throw new XMLParseException("DownstreamPackets", "Node has an invalid value.");
                        }
                        object5 = element3.getElementsByTagName("ChannelTimeout");
                        if (object5.getLength() == 0) {
                            throw new XMLParseException("##__null__##", "ChannelTimeout node expected in received XML structure.");
                        }
                        Element element4 = (Element)object5.item(0);
                        long l = XMLUtil.parseValue((Node)element4, -1);
                        if (l < 1L) {
                            throw new XMLParseException("ChannelTimeout node has an invalid value.");
                        }
                        l = 1000L * l;
                        object4 = element3.getElementsByTagName("ChainTimeout");
                        if (object4.getLength() == 0) {
                            throw new XMLParseException("##__null__##", "ChainTimeout node expected in received XML structure.");
                        }
                        element = (Element)object4.item(0);
                        long l2 = XMLUtil.parseValue((Node)element, -1);
                        if (l2 < 1L) {
                            throw new XMLParseException("ChainTimeout", "Node has an invalid value.");
                        }
                        l2 = 1000L * l2;
                        this.m_fixedRatioChannelsDescription = new FixedRatioChannelsDescription(n3, l, l2);
                        continue;
                    }
                    throw new UnknownProtocolVersionException("Unknown chain protocol version used ('" + (String)object8 + "').");
                }
                if (i != 0 || XMLUtil.getFirstChildByName(element3, "SupportsEncrypedControlChannels") == null) continue;
                this.m_controlchannelCipher = new ControlChannelCipher();
            }
            this.m_multiplexerInputStreamCipher = new SymCipher();
            this.m_multiplexerOutputStreamCipher = new SymCipher();
            KeyPool.start();
            LogHolder.log(7, LogType.NET, "Starting key exchange...");
            if (this.m_firstMixSymmetricCipher == null) {
                object3 = new MixPacket(0);
                object2 = "KEYPACKET".getBytes();
                System.arraycopy(object2, 0, ((MixPacket)object3).getPayloadData(), 0, ((Object)object2).length);
                object = new byte[32];
                KeyPool.getKey((byte[])object, 0);
                KeyPool.getKey((byte[])object, 16);
                System.arraycopy(object, 0, ((MixPacket)object3).getPayloadData(), ((Object)object2).length, ((Object)object).length);
                this.m_mixParameters[0].getMixCipher().encrypt(((MixPacket)object3).getPayloadData(), 0, ((MixPacket)object3).getPayloadData(), 0);
                outputStream.write(((MixPacket)object3).getRawPacket());
                this.m_multiplexerInputStreamCipher.setEncryptionKeyAES((byte[])object, 0, 16);
                this.m_multiplexerOutputStreamCipher.setEncryptionKeyAES((byte[])object, 16, 16);
            } else {
                int n4;
                int n5;
                object3 = XMLUtil.createDocument();
                if (object3 == null) {
                    throw new XMLParseException("Cannot create XML document for key exchange.");
                }
                object2 = object3.createElement("JAPKeyExchange");
                object2.setAttribute("version", "0.1");
                object = object3.createElement("LinkEncryption");
                object11 = new byte[64];
                KeyPool.getKey((byte[])object11, 0);
                KeyPool.getKey((byte[])object11, 16);
                KeyPool.getKey((byte[])object11, 32);
                KeyPool.getKey((byte[])object11, 48);
                this.m_multiplexerOutputStreamCipher.setEncryptionKeyAES((byte[])object11, 0, 32);
                this.m_multiplexerInputStreamCipher.setEncryptionKeyAES((byte[])object11, 32, 32);
                XMLUtil.setValue((Node)object, Base64.encode((byte[])object11, true));
                object2.appendChild((Node)object);
                object10 = object3.createElement("MixEncryption");
                object9 = new byte[32];
                KeyPool.getKey((byte[])object9, 0);
                KeyPool.getKey((byte[])object9, 16);
                this.m_firstMixSymmetricCipher.setEncryptionKeyAES((byte[])object9, 0, 32);
                XMLUtil.setValue((Node)object10, Base64.encode((byte[])object9, true));
                object2.appendChild((Node)object10);
                object3.appendChild((Node)object2);
                if (this.m_controlchannelCipher != null) {
                    object8 = object3.createElement("ControlChannelEncryption");
                    object7 = new byte[32];
                    KeyPool.getKey((byte[])object7, 0);
                    KeyPool.getKey((byte[])object7, 16);
                    this.m_controlchannelCipher.setSentKey((byte[])object7, 0, 16);
                    this.m_controlchannelCipher.setRecvKey((byte[])object7, 16, 16);
                    XMLUtil.setValue((Node)object8, Base64.encode((byte[])object7, true));
                    object2.appendChild((Node)object8);
                }
                object8 = object3.createElement("ReplayDetection");
                if (this.m_protocolWithReplay) {
                    XMLUtil.setValue((Node)object8, "true");
                } else {
                    XMLUtil.setValue((Node)object8, "false");
                }
                object2.appendChild((Node)object8);
                XMLEncryption.encryptElement((Element)object2, this.m_mixParameters[0].getMixCipher().getPublicKey());
                object7 = new ByteArrayOutputStream();
                object6 = XMLUtil.toByteArray((Node)object3);
                DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)object7);
                dataOutputStream.writeShort(((Object)object6).length);
                dataOutputStream.flush();
                ((OutputStream)object7).write((byte[])object6);
                ((OutputStream)object7).flush();
                object5 = ((ByteArrayOutputStream)object7).toByteArray();
                outputStream.write((byte[])object5);
                outputStream.flush();
                byte[] byArray2 = new byte[n5];
                for (n5 = dataInputStream.readUnsignedShort(); n5 > 0; n5 -= n4) {
                    n4 = inputStream.read(byArray2, byArray2.length - n5, n5);
                    if (n4 != -1) continue;
                    throw new EOFException("EOF detected while reading symmetric key signature XML structure.");
                }
                Document document = XMLUtil.toXMLDocument(byArray2);
                object4 = null;
                if (this.m_protocolWithReplay) {
                    element = document.getDocumentElement();
                    Element element5 = (Element)element.getFirstChild();
                    Element element6 = (Element)element5.getFirstChild();
                    for (int i = 0; i < this.m_cascade.getNumberOfMixes(); ++i) {
                        for (int j = 0; j < this.m_cascade.getNumberOfMixes(); ++j) {
                            if (!element6.getAttribute("id").equals(this.m_mixParameters[j].getMixId())) continue;
                            this.m_mixParameters[j].setReplayOffset(Integer.parseInt(element6.getFirstChild().getFirstChild().getNodeValue()));
                        }
                        element6 = (Element)element6.getNextSibling();
                    }
                    MixParameters.m_referenceTime = System.currentTimeMillis() / 1000L;
                    object4 = (Element)element.getLastChild();
                } else {
                    object4 = document.getDocumentElement();
                }
                if (object4 == null) {
                    throw new XMLParseException("##__root__##", "No document element in received symmetric key signature XML structure.");
                }
                object3.getDocumentElement().appendChild(XMLUtil.importNode((Document)object3, (Node)object4, true));
                if (!XMLSignature.verifyFast((Node)object3, this.m_cascade.getCertPath().getEndEntityKeys())) {
                    throw new SignatureException("Invalid symmetric keys signature received.");
                }
            }
            if (this.m_cascade.isTermsAndConditionsConfirmationRequired()) {
                if (this.m_tnCRequest.hasResourceRequests()) {
                    object3 = XMLUtil.createDocument();
                    object2 = this.m_tnCRequest.toXmlElement((Document)object3);
                    object = XMLUtil.toString((Node)object3);
                    if (object != null) {
                        object11 = new ByteArrayOutputStream();
                        object10 = new DataOutputStream((OutputStream)object11);
                        ((DataOutputStream)object10).writeShort(((String)object).length());
                        ((DataOutputStream)object10).writeBytes((String)object);
                        outputStream.write(((ByteArrayOutputStream)object11).toByteArray());
                        outputStream.flush();
                        int n6 = dataInputStream.readInt();
                        object8 = new byte[n6];
                        inputStream.read((byte[])object8, 0, n6);
                        object7 = XMLUtil.toXMLDocument((byte[])object8);
                        if (object7 != null) {
                            TermsAndConditionsResponseHandler.get().handleXMLResourceResponse((Document)object7, this.m_tnCRequest);
                        }
                    }
                }
                object3 = XMLUtil.createDocument();
                object2 = null;
                if (this.tcrException != null) {
                    object2 = object3.createElement("TermsAndConditionsInterrupt");
                } else {
                    object2 = object3.createElement("TermsAndConditionsConfirm");
                    XMLUtil.setAttribute((Element)object2, "accepted", true);
                }
                object3.appendChild((Node)object2);
                object = XMLUtil.toString((Node)object3);
                object11 = new ByteArrayOutputStream();
                object10 = new DataOutputStream((OutputStream)object11);
                ((DataOutputStream)object10).writeShort(((String)object).length());
                ((DataOutputStream)object10).writeBytes((String)object);
                outputStream.write(((ByteArrayOutputStream)object11).toByteArray());
                outputStream.flush();
                if (this.tcrException != null) {
                    throw this.tcrException;
                }
            }
        }
        catch (SignatureException signatureException) {
            this.removeCertificateLock();
            throw signatureException;
        }
    }

    public boolean isProtocolWithTimestamp() {
        return this.m_protocolWithTimestamp;
    }

    public boolean isPaymentRequired() {
        return this.m_paymentRequired;
    }

    public boolean isChainProtocolWithFlowControl() {
        return this.m_chainProtocolWithFlowControl;
    }

    public int getUpstreamSendMe() {
        return this.m_upstreamSendMe;
    }

    public int getDownstreamSendMe() {
        return this.m_downstreamSendMe;
    }

    public FixedRatioChannelsDescription getFixedRatioChannelsDescription() {
        return this.m_fixedRatioChannelsDescription;
    }

    public SymCipher getFirstMixSymmetricCipher() {
        return this.m_firstMixSymmetricCipher;
    }

    public SymCipher getMultiplexerInputStreamCipher() {
        return this.m_multiplexerInputStreamCipher;
    }

    public SymCipher getMultiplexerOutputStreamCipher() {
        return this.m_multiplexerOutputStreamCipher;
    }

    public MixParameters[] getMixParameters() {
        return this.m_mixParameters;
    }

    public MixCascade getConnectedCascade() {
        return this.m_cascade;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCertificateLock() {
        Object object = this.m_internalSynchronization;
        synchronized (object) {
            if (this.m_mixCascadeCertificateLock != -1) {
                SignatureVerifier.getInstance().getVerificationCertificateStore().removeCertificateLock(this.m_mixCascadeCertificateLock);
                this.m_mixCascadeCertificateLock = -1;
            }
        }
    }

    public boolean isProtocolWithEnhancedChannelEncryption() {
        return this.m_bEnhancedChannelEncryption;
    }

    public ControlChannelCipher getControlChannelCipher() {
        return this.m_controlchannelCipher;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

